#Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. 
#Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with the License.
#A copy of the License is located at http://aws.amazon.com/apache2.0/
#or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS 
#OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.

# Filename: storagespaces_smb_server.ps1
# This script creates a Storage Space drive on the server, and shares it.

$drive = "E"

# Unformat the EBS volumes so they can be pooled.
# Hopefully the Where clauses avoid erasing unintended disks!
Get-Disk | Where-Object Size GE 40GB | Clear-Disk RemoveData
Get-PhysicalDisk | Where-Object Size GE 40GB | Reset-PhysicalDisk

# Create the storage pool
New-StoragePool FriendlyName ConcretePool StorageSubsystemFriendlyName "Storage Spaces*" PhysicalDisks(Get-PhysicalDisk CanPool $True)

# Set the media types for storage tiering.
# The Where clauses differentiate SSD/HDD volumes given some rounding.
# The HDD was created as 50 GB in CloudFormation.
# The SSD was created as 40 GB in CloudFormation.
Get-PhysicalDisk | Where-Object Size GT 39GB | Where-Object Size LT 41GB | Set-PhysicalDisk -MediaType SSD
Get-PhysicalDisk | Where-Object Size GT 49GB | Where-Object Size LT 51GB | Set-PhysicalDisk -MediaType HDD

# Create a virtual disk in the pool. The size allows for some rounding.
New-VirtualDisk FriendlyName vdisk1 StoragePoolFriendlyName ConcretePool Size 87GB ResiliencySettingName Simple ProvisioningType Fixed

# Create a partition on the virtual disk and format it
Get-VirtualDisk FriendlyName vdisk1 |
Get-Disk |
Initialize-Disk -PassThru |
New-Partition UseMaximumSize -DriveLetter $drive
Format-Volume DriveLetter $drive FileSystem NTFS -Confirm:$False

# Let format complete before creating share
Start-Sleep Seconds 5

# Share a folder on the disk
$path = ("{0}:\MyShare" -f $drive)
New-Item $path -Type Directory
New-SmbShare -Name Myshare -Path $path -FullAccess Administrator