#Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. 
#Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with the License.
#A copy of the License is located at http://aws.amazon.com/apache2.0/
#or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS 
#OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.

# Filename: storagespaces_iscsi_server.ps1
# This script creates an iscsi drive on the server with CHAP.

# Run iscsicli on the client and insert here.
$clientIQN = "OUTPUT FROM iscsicli ON THE CLIENT, WITHOUT BRACKETS"
$username = "user"
$password = "12characters"    # must be 12-16 characters long
$drive = "E"
$size = 85GB
$target = "mytarget"

# Install Iscsi Target Feature
Install-WindowsFeature -Name FS-iSCSITarget-Server -IncludeManagementTools

# Enable iSCSI ports in Windows Firewall
netsh advfirewall firewall add rule name="iscsi-in" protocol=TCP dir=in localport="860,3260" action=allow
netsh advfirewall firewall add rule name="iscsi-out" protocol=TCP dir=out localport="860,3260" action=allow

# Create a virtual disk, without formatting
$vdisk = $drive+":\iscsi\vdisk.vhdx"
New-IscsiVirtualDisk -Path $vdisk -Size $size -UseFixed DoNotClearData 

# create a target called "mytarget" for the client instance to access
New-IscsiServerTarget -TargetName $target -InitiatorIds "IQN:$clientIQN"

# Require initiators to connect via CHAP as user "user" with password
$SecurePassword = ConvertTo-SecureString -String $password -AsPlainText -Force
$chap = New-Object System.Management.Automation.PSCredential($username, $SecurePassword)
Set-IscsiServerTarget TargetName $target -EnableChap $true -Chap $chap 

# Map the iscsi target name to the virtual disk
Add-IscsiVirtualDiskTargetMapping -TargetName $target -Path $vdisk