#Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. 
#Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with the License.
#A copy of the License is located at http://aws.amazon.com/apache2.0/
#or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS 
#OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.

# Filename: storagespaces_iscsi_client2.ps1
# This script formats the iscsi volume on the client and writes to it.

# Edit these values...
$serverIP = "YOUR SERVER IP ADDRESS"
$serverIQN = "RUN Get-IscsiServerTarget ON THE SERVER AND COPY TARGET IQN"
$username = "user"
$password = "12characters"   # must be 12-16 characters
$drive = "E"

# Enable iSCSI ports in Windows Firewall
netsh advfirewall firewall add rule name="iscsi-in" protocol=TCP dir=in localport="860,3260" action=allow
netsh advfirewall firewall add rule name="iscsi-out" protocol=TCP dir=out localport="860,3260" action=allow

# Connect to ISCSI
New-IscsiTargetPortal TargetPortalAddress $serverIP
Connect-IscsiTarget -NodeAddress $serverIQN -AuthenticationType ONEWAYCHAP -ChapUsername $username -ChapSecret $password
Start-Sleep Seconds 5  # give the connection time to initialize

# Format the drive and bring it online
$number = (Get-Disk | Where Size -GT 84GB | Where Size -LT 90GB | Where PartitionStyle -EQ 'RAW').Number
Set-Disk -Number $number -IsReadOnly 0 
Set-Disk -Number $number -IsOffline 0 
Initialize-Disk -Number $number
New-Partition -DiskNumber $number -DriveLetter $drive -UseMaximumSize
Start-Sleep Seconds 5
Format-Volume -DriveLetter $drive -FileSystem NTFS -Force
Start-Sleep Seconds 5

# Copy a text file to the iscsi virtual disk.
$filename = $drive+":\iscsi_test.txt"
@'
Hello AWS from ISCSI!
'@ > $filename
